*******************************************************************************
*                          680xx Grundprogramm ser                            *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                 Routinen fr die seriellen Schnittstellen                   *
*******************************************************************************


siinit:                         * INIT seriellen Schnittstellen
 btst.b #4, d0                  * externer Takt bei SER nicht vorhanden,
 beq.s siinit20                 * daher muss es die SER2 sein!
 move.b d0,ser3.w               * Controlregister bertragen
 move.b d1,ser2.w               * Command Register
rts

siinit20:                       * SER2 initialisieren
 move.l d1, -(a7)
 move.b #$03, ser2e.w           * LEDs ausschalten
 move.b cpu(a5), d1             * fuer Warteschleife
 btst.b #0, d0
 bne.s siinit30                 * Kanal B initialisieren
 move.b (a0)+, ser21.w          * Setze Baudrate
 bsr siwait
 move.b (a0)+, ser20.w          * Parity, Anzahl Bits
 bsr siwait
 move.b (a0)+, ser20.w          * Stop Bits
 bsr siwait
 move.b (a0)+, ser22.w          * Setze Extent Bit fuer Rx Cha A
 bsr siwait 
 move.b (a0)+, ser22.w          * Setze Extent Bit fuer Tx Cha A
 bsr siwait
 move.b (a0)+, ser22.w          * Starte Channel A
 move.l (a7)+, d1
 rts
 
siinit30:
 move.b (a0)+, ser29.w          * Setze Baudrate
 bsr siwait
 move.b (a0)+, ser28.w          * Parity, Anzahl Bits
 bsr siwait
 move.b (a0)+, ser28.w          * Stop Bits
 bsr siwait
 move.b (a0)+, ser2a.w          * Setze Extent Bit fuer Rx Cha B
 bsr siwait 
 move.b (a0)+, ser2a.w          * Setze Extent Bit fuer Tx Cha B
 bsr siwait
 move.b (a0)+, ser2a.w          * Starte Channel B
 move.l (a7)+, d1
 rts 

siwait:
 cmp.b #1, d1                   * 68008
 beq.s siwaitex
 nop
 cmp.b #2, d1                   * 68000
 beq.b siwaitex
 nop                            * 68020
 nop
 nop
siwaitex:
 rts
 
si:                             * Zeichen von serieller Schnittstelle
 cmp.b #1, aktser(a5)
 beq.s si11                     * SER1
 bhi.s si21                     * SER2?
 bra.s siex                     * keine SER!!!
si21:
 cmp.b #2, aktser(a5)
 bhi.s si31                     * SER2 Kanal B
 btst.b #0, ser21.w             * Stehen Daten in Empfangsfifo Kanal A ?
 beq.s si21                     * nein, warten
 move.b ser23.w, d0             * Byte aus Empfangsfifo holen
 bra.s siex
si31:
 btst.b #0, ser29.w             * Stehen Daten in Empfangsfifo Kanal B ?
 beq.s si31                     * nein, warten
 move.b ser2b.w, d0             * Byte aus Empfangsfifo holen
 bra.s siex 
si11:
 btst.b #3,ser1.w
 beq.s si11                     * Warten bis Zeichen vorhanden
 moveq #0,d0
 move.b ser0.w,d0               * Zeichen holen
siex:
 rts

si2:
 cmp.b #1, aktser(a5)
 bhi.s si21                     * SER2?, dann ohne RTS weiter
 bset.b #3,ser2.w               * RTS auf High
si2a:                           * Zeichen von serieller Schnittstelle holen
 btst.b #3,ser1.w               * Prfen, ob ein Zeichen da ist
 beq.s si2a                     * Versuchen bis OK
 bclr.b #3,ser2.w               * RTS auf Low
 moveq #0,d0                    * Langwort gltig
 move.b ser0.w,d0               * Datenbyte holen
 rts

so:                             * Zeichen an serielle Schnittstelle
 cmp.b #1, aktser(a5)
 beq.s so11                     * SER1
 bhi.s so21                     * SER2?
 bra.s soex                     * keine SER!!!
so21:
 cmp.b #2, aktser(a5)
 bhi.s so31                     * SER2 Kanal B
 btst.b #2, ser21.w             * Ausgaberegister Kanal A leer ?
 beq.s so21                     * Nein -> weiter warten
 move.b d0, ser23.w             * Byte ins Ausgaberegister
 bra.b soex
so31:
 btst.b #2, ser29.w             * Ausgaberegister Kanal B leer ?
 beq.s so31                     * Nein -> weiter warten
 move.b d0, ser2b.w             * Byte ins Ausgaberegister
 bra.b soex 
so11: 
 btst.b #6,ser1.w               * Warten bis bereit
 bne.s so11
so12:
 btst.b #4,ser1.w               * Warten bis SERbuffer frei ist
 beq.s so12
 move.b d0,ser0.w               * Dann Zeichen ausgeben
soex:
 rts

sists:                          * Prfen, ob Zeichen von SER vorliegt
 cmp.b #1, aktser(a5)
 beq.s sists11                  * SER1
 bhi.s sists21                  * SER2?
 bra.s sisno                    * keine SER!!! also keine Daten ;)
sists21:
 cmp.b #2, aktser(a5)
 bhi.s sists31                  * SER2 Kanal B
 btst.b #0, ser21.w             * Stehen Daten in Empfangsfifo Kanal A ?
 beq.s sisno                    * nein
 bra.s sisyes
sists31:
 btst.b #0, ser29.w             * Stehen Daten in Empfangsfifo Kanal B ?
 beq.s sisno                    * nein
 bra.s sisyes
sists11:
 btst.b #3,ser1.w               * vorliegt
 beq.s sisno
sisyes:
 moveq #-1,d0                   * Zeichen vorhanden
rts
sisno:
sosno:
 moveq #0,d0                    * Kein Zeichen
rts

sosts:                          * Test, ob Zeichen gesendet werden kann
 cmp.b #1, aktser(a5)
 beq.s sosts11                  * SER1
 bhi.s sosts21                  * SER2?
 bra.s sosno                    * keine SER!!! also keine Daten ;)
sosts21:
 cmp.b #2, aktser(a5)
 bhi.s sosts31                  * SER2 Kanal B
 btst.b #2, ser21.w             * Ausgaberegister Kanal A leer ?
 beq.s sosno                    * Nein
 bra.b sosyes
sosts31:
 btst.b #2, ser29.w             * Ausgaberegister Kanal B leer ?
 beq.s sosno                    * Nein
 bra.b sosyes	
sosts11:
 btst.b #6,ser1.w
 bne.s sosno
sosyes:
 moveq #-1,d0                   * Zeichen kann gesendet werden
rts

setser:                         * Der aktuelle SER-Kanal wird gesetzt
 move.l d1, -(a7)
 clr d1
 btst.b #2, ioflag(a5)          * SER da?
 beq.s setser01
 moveq #1, d1
setser01:
 btst.b #3, ioflag(a5)          * SER2 da?
 beq.s setser02
 moveq #3, d1
setser02:
 and d1, d0                     * z.Zt. nur bis Kanal 3
 beq.s setserer                 * kein gltiger Kanal
 cmp.b #1, d0
 bhi.s setser20                 * SER2 ist gemeint
 btst.b #2, ioflag(a5)          * SER da?
 beq.s setserer                 * nein, dann Fehler
 move.b d0, aktser(a5)
 move.b #$03, ser2e.w           * LEDs ausschalten 
 bra.s setserex                 * Fertig
setser20:
 btst.b #3, ioflag(a5)          * SER2 vorhanden?
 beq.s setserer                 * nein, dann Fehler
 move.b d0, aktser(a5)
 subq.b #1, d0                  * auf 1 oder 2
 move.b d0, ser2f.w             * und LED an
 addq.b #1, d0                  * wieder herstellen
 bra.s setserex
setserer:
 moveq #-1, d0
setserex:
 move.l (a7)+, d1
 rts
 
getser:                         * Lade den aktuellen SER-Kanal
 clr d0
 move.b aktser(a5), d0
 rts

s2bd2400:                       * SER2 2400,N,8,1
 dc.b $88, $13, $07, $90, $b0, $15

s2bd9600:                       * SER2 9600,N,8,1
 dc.b $bb, $13, $07, $80, $a0, $15

s2bd19k2:                       * SER2 19k2,N,8,1
 dc.b $cc, $13, $07, $80, $a0, $15

s2bd28k8:                       * SER2 28k8,N,8,1
 dc.b $66, $13, $07, $80, $a0, $15

s2bd57k6:                       * SER2 57k6,N,8,1
 dc.b $77, $13, $07, $80, $a0, $15
 
s2bd115k:                       * SER2 115k,N,8,1
 dc.b $88, $13, $07, $80, $a0, $15
                                                                                                                                                                                                                                                                                                                                                                                                                                        